APPLE1	=1

ASCONE	='1'
INMASK	=$7F		; mask out the high bit for keyboard input

ESC	=$1B		; escape
SP	=$20		; space
CR	=$0D		; carriage return
LF	=$0A		; line feed

FROM	=$50		; move from MISCL,H
TO	=$52		; to MISCL2,H
SIZEL	=$54
SIZEH	=$55

DEST	=$2000

ASSEM   =$F01C
MOVE    =$F20E

	.org $A000
	.start MAIN

MAIN	
	JSR SHOW	; show the menu
	JSR GETCH	; get the input
	JSR OUTCH
	CMP #ESC
	BEQ .STOP
	SEC
	SBC #ASCONE	; subtract ASCII '1' to get offfset
	CMP #NUM	; Are we in range?
	BCS .CONT	; Too large
	TAX		; X now holds offset for the selected item
	JSR CRLF
	JSR SELECT	; jump to the appropriate routine
.CONT	JMP MAIN	; loop forever
.STOP	RTS
	
SHOW	
	JSR CRLF
	LDX #$FF	; data
.NEXT	INX
	LDA MNUDAT,X
	BNE .NOTEOL
	JSR CRLF
	JMP .NEXT
.NOTEOL	CMP #$FF
	BEQ .DONE
	JSR OUTCH
	JMP .NEXT
.DONE	RTS
	
SELECT	
	LDA SRCL,X
	STA FROM
	LDA SRCH,X
	STA FROM+1
	LDA SZL,X
	STA SIZEL
	LDA SZH,X
	STA SIZEH
	LDA #<DEST
	STA TO
	LDA #>DEST
	STA TO+1
	JSR MOVE
	JMP ASSEM
  	
; ****************************************
; I/O routines
; ****************************************

CRLF			; Go to a new line.
	LDA #CR		; "CR"
	.if APPLE1
	JMP OUTCH
	.else
	JSR OUTCH
	LDA #LF		; "LF" - is this needed for the Apple 1?
	JMP OUTCH
	.endif
	RTS

GETCH   		; Get a character from the keyboard.
	LDA KBDRDY
	.if APPLE1
	BPL GETCH
	LDA KBD
	AND #INMASK
	.else
	BEQ GETCH
	.endif
	RTS
	
; Menu data

NUM	=$03		; Number of options in the menu
MNUDAT	.ascii	"CHOOSE SOURCE TO LOAD"
	.byte	$00
	.ascii	"1. MASTERMIND"
	.byte	$00
	.ascii	"2. 100 GAME"
	.byte	$00
	.ascii	"3. NIM"	
	.byte	$00
	.ascii	"> "
	.byte	$FF
	
MM
	.byte $54, $52, $49, $45, $53, $01, $3E, $24
	.byte $45, $32, $00, $52, $4E, $44, $4C, $01
	.byte $3E, $24, $45, $33, $00, $52, $4E, $44
	.byte $48, $01, $3E, $24, $45, $34, $00, $52
	.byte $4E, $44, $32, $4C, $01, $3E, $24, $45
	.byte $35, $00, $4E, $01, $3E, $24, $45, $36
	.byte $00, $47, $55, $45, $53, $53, $01, $3E
	.byte $24, $45, $42, $00, $02, $00, $43, $4F
	.byte $55, $54, $01, $3E, $24, $46, $46, $45
	.byte $46, $00, $50, $52, $42, $59, $54, $45
	.byte $01, $3E, $24, $46, $46, $44, $43, $00
	.byte $4B, $42, $44, $01, $3E, $24, $44, $30
	.byte $31, $30, $00, $53, $54, $52, $4F, $42
	.byte $45, $01, $3E, $24, $44, $30, $31, $31
	.byte $00, $02, $00, $4D, $53, $54, $4D, $4E
	.byte $44, $01, $4E, $24, $33, $30, $30, $00
	.byte $01, $36, $23, $24, $38, $00, $4D, $53
	.byte $47, $4C, $50, $01, $2E, $4D, $53, $47
	.byte $2D, $31, $2C, $58, $00, $01, $22, $43
	.byte $4F, $55, $54, $00, $01, $15, $00, $01
	.byte $20, $4D, $53, $47, $4C, $50, $00, $01
	.byte $35, $54, $52, $49, $45, $53, $00, $52
	.byte $4E, $44, $4C, $50, $01, $38, $52, $4E
	.byte $44, $4C, $00, $01, $20, $52, $4E, $44
	.byte $32, $00, $01, $38, $52, $4E, $44, $48
	.byte $00, $52, $4E, $44, $32, $01, $2E, $53
	.byte $54, $52, $4F, $42, $45, $00, $01, $1A
	.byte $52, $4E, $44, $4C, $50, $00, $01, $22
	.byte $43, $48, $41, $52, $49, $4E, $00, $4E
	.byte $58, $54, $52, $59, $01, $04, $00, $01
	.byte $10, $00, $01, $11, $00, $01, $2C, $54
	.byte $52, $49, $45, $53, $00, $01, $2D, $54
	.byte $52, $49, $45, $53, $00, $01, $0E, $00
	.byte $4E, $58, $54, $4C, $49, $4E, $01, $22
	.byte $43, $52, $4C, $46, $00, $01, $2E, $54
	.byte $52, $49, $45, $53, $00, $01, $22, $50
	.byte $52, $42, $59, $54, $45, $00, $01, $2E
	.byte $23, $24, $41, $30, $00, $01, $0B, $00
	.byte $01, $22, $43, $4F, $55, $54, $00, $01
	.byte $2E, $52, $4E, $44, $4C, $00, $01, $2D
	.byte $52, $4E, $44, $32, $4C, $00, $01, $2E
	.byte $52, $4E, $44, $48, $00, $01, $36, $23
	.byte $24, $35, $00, $44, $49, $47, $45, $4E
	.byte $01, $25, $4E, $2D, $31, $2C, $58, $00
	.byte $01, $26, $23, $24, $33, $00, $42, $49
	.byte $54, $47, $45, $4E, $01, $33, $00, $01
	.byte $32, $52, $4E, $44, $32, $4C, $00, $01
	.byte $32, $4E, $2D, $31, $2C, $58, $00, $01
	.byte $09, $00, $01, $20, $42, $49, $54, $47
	.byte $45, $4E, $00, $01, $15, $00, $01, $20
	.byte $44, $49, $47, $45, $4E, $00, $52, $44
	.byte $4B, $45, $59, $01, $22, $43, $48, $41
	.byte $52, $49, $4E, $00, $01, $22, $43, $4F
	.byte $55, $54, $00, $01, $2B, $23, $24, $42
	.byte $30, $00, $01, $2F, $23, $24, $38, $00
	.byte $01, $1F, $4E, $58, $54, $4C, $49, $4E
	.byte $00, $01, $2D, $47, $55, $45, $53, $53
	.byte $2B, $34, $2C, $58, $00, $01, $15, $00
	.byte $01, $28, $23, $24, $46, $42, $00, $01
	.byte $20, $52, $44, $4B, $45, $59, $00, $01
	.byte $26, $23, $24, $46, $42, $00, $01, $2E
	.byte $23, $24, $41, $30, $00, $50, $4C, $55
	.byte $53, $31, $01, $22, $43, $4F, $55, $54
	.byte $00, $50, $4C, $55, $53, $32, $01, $2E
	.byte $47, $55, $45, $53, $53, $2B, $35, $2C
	.byte $58, $00, $01, $2F, $4E, $2B, $35, $2C
	.byte $58, $00, $01, $20, $50, $4C, $55, $53
	.byte $33, $00, $01, $25, $4E, $2B, $35, $2C
	.byte $58, $00, $01, $2E, $23, $24, $41, $42
	.byte $00, $01, $2D, $47, $55, $45, $53, $53
	.byte $2B, $35, $2C, $58, $00, $01, $0D, $00
	.byte $01, $20, $50, $4C, $55, $53, $31, $00
	.byte $01, $36, $23, $24, $31, $31, $00, $01
	.byte $20, $4D, $53, $47, $4C, $50, $00, $50
	.byte $4C, $55, $53, $33, $01, $0F, $00, $01
	.byte $20, $50, $4C, $55, $53, $32, $00, $01
	.byte $26, $23, $24, $46, $42, $00, $4D, $49
	.byte $4E, $55, $53, $31, $01, $36, $47, $55
	.byte $45, $53, $53, $2B, $35, $2C, $59, $00
	.byte $01, $11, $00, $01, $36, $23, $24, $46
	.byte $42, $00, $4D, $49, $4E, $55, $53, $32
	.byte $01, $2F, $4E, $2B, $35, $2C, $58, $00
	.byte $01, $20, $4D, $49, $4E, $55, $53, $33
	.byte $00, $01, $25, $4E, $2B, $35, $2C, $58
	.byte $00, $01, $2E, $23, $24, $41, $44, $00
	.byte $01, $22, $43, $4F, $55, $54, $00, $4D
	.byte $49, $4E, $55, $53, $33, $01, $0F, $00
	.byte $01, $20, $4D, $49, $4E, $55, $53, $32
	.byte $00, $01, $0D, $00, $01, $20, $4D, $49
	.byte $4E, $55, $53, $31, $00, $01, $21, $4E
	.byte $58, $54, $52, $59, $00, $4D, $53, $47
	.byte $01, $43, $24, $42, $46, $00, $01, $43
	.byte $24, $44, $39, $00, $01, $43, $24, $43
	.byte $34, $00, $01, $43, $24, $43, $31, $00
	.byte $01, $43, $24, $43, $35, $00, $01, $43
	.byte $24, $44, $32, $00, $01, $43, $24, $38
	.byte $44, $00, $01, $43, $24, $38, $44, $00
	.byte $01, $43, $24, $43, $45, $00, $01, $43
	.byte $24, $43, $39, $00, $01, $43, $24, $44
	.byte $37, $00, $01, $43, $24, $41, $30, $00
	.byte $01, $43, $24, $44, $35, $00, $01, $43
	.byte $24, $43, $46, $00, $01, $43, $24, $44
	.byte $39, $00, $01, $43, $24, $41, $30, $00
	.byte $01, $43, $24, $41, $42, $00, $43, $52
	.byte $4C, $46, $01, $2E, $23, $24, $38, $44
	.byte $00, $01, $24, $43, $4F, $55, $54, $00
	.byte $43, $48, $41, $52, $49, $4E, $01, $2E
	.byte $53, $54, $52, $4F, $42, $45, $00, $01
	.byte $1A, $43, $48, $41, $52, $49, $4E, $00
	.byte $01, $2E, $4B, $42, $44, $00, $01, $19
	.byte $00, $00
HG	
	.byte $45, $43, $48, $4F, $01, $3E, $24, $46
	.byte $46, $45, $46, $00, $50, $52, $48, $45
	.byte $58, $01, $3E, $24, $46, $46, $45, $35
	.byte $00, $4F, $55, $54, $48, $45, $58, $01
	.byte $3E, $24, $46, $46, $44, $43, $00, $4B
	.byte $42, $44, $01, $3E, $24, $44, $30, $31
	.byte $30, $00, $4B, $42, $44, $52, $44, $59
	.byte $01, $3E, $24, $44, $30, $31, $31, $00
	.byte $02, $00, $46, $41, $49, $4C, $01, $3E
	.byte $24, $46, $46, $00, $43, $52, $01, $3E
	.byte $24, $30, $44, $00, $53, $50, $01, $3E
	.byte $24, $32, $30, $00, $02, $00, $49, $4F
	.byte $42, $55, $46, $01, $3E, $24, $30, $30
	.byte $00, $53, $43, $52, $54, $43, $48, $01
	.byte $3E, $24, $30, $32, $00, $4D, $53, $47
	.byte $4C, $01, $3E, $24, $30, $33, $00, $4D
	.byte $53, $47, $48, $01, $3E, $24, $30, $34
	.byte $00, $53, $55, $4D, $01, $3E, $24, $30
	.byte $35, $00, $54, $41, $52, $47, $45, $54
	.byte $01, $3E, $24, $30, $36, $00, $54, $55
	.byte $52, $4E, $01, $3E, $24, $30, $37, $00
	.byte $02, $00, $45, $52, $52, $4F, $52, $01
	.byte $54, $27, $49, $4E, $56, $41, $4C, $49
	.byte $44, $27, $00, $01, $43, $24, $30, $00
	.byte $59, $4F, $55, $01, $54, $27, $59, $4F
	.byte $55, $27, $00, $01, $43, $24, $30, $00
	.byte $57, $49, $4E, $01, $54, $27, $57, $49
	.byte $4E, $21, $27, $00, $01, $43, $24, $30
	.byte $00, $4C, $4F, $53, $45, $01, $54, $27
	.byte $4C, $4F, $53, $45, $21, $27, $00, $01
	.byte $43, $24, $30, $00, $43, $4D, $50, $50
	.byte $4C, $59, $01, $54, $27, $49, $27, $00
	.byte $01, $43, $53, $50, $00, $01, $54, $27
	.byte $50, $4C, $41, $59, $27, $00, $01, $43
	.byte $53, $50, $00, $01, $43, $24, $30, $00
	.byte $53, $55, $4D, $4C, $4E, $01, $54, $27
	.byte $53, $55, $4D, $27, $00, $01, $43, $53
	.byte $50, $00, $01, $54, $27, $49, $53, $27
	.byte $00, $01, $43, $53, $50, $00, $01, $43
	.byte $24, $30, $00, $02, $00, $47, $45, $54
	.byte $43, $48, $01, $4E, $00, $01, $2E, $4B
	.byte $42, $44, $52, $44, $59, $00, $01, $1A
	.byte $47, $45, $54, $43, $48, $00, $01, $2E
	.byte $4B, $42, $44, $00, $01, $2A, $23, $24
	.byte $37, $46, $00, $01, $19, $00, $02, $00
	.byte $50, $52, $4F, $4D, $50, $54, $01, $4E
	.byte $00, $01, $2E, $23, $27, $3F, $27, $00
	.byte $01, $22, $45, $43, $48, $4F, $00, $4F
	.byte $55, $54, $53, $50, $01, $4E, $00, $01
	.byte $2E, $23, $53, $50, $00, $01, $24, $45
	.byte $43, $48, $4F, $00, $02, $00, $43, $52
	.byte $4C, $46, $01, $4E, $00, $01, $2E, $23
	.byte $43, $52, $00, $01, $24, $45, $43, $48
	.byte $4F, $00, $02, $00, $50, $52, $56, $41
	.byte $4C, $01, $4E, $00, $01, $2F, $23, $24
	.byte $31, $30, $00, $01, $1E, $2E, $4E, $4F
	.byte $54, $45, $4E, $00, $01, $22, $4F, $55
	.byte $54, $48, $45, $58, $00, $01, $20, $2E
	.byte $53, $4B, $49, $50, $00, $2E, $4E, $4F
	.byte $54, $45, $4E, $01, $22, $50, $52, $48
	.byte $45, $58, $00, $2E, $53, $4B, $49, $50
	.byte $01, $24, $43, $52, $4C, $46, $00, $02
	.byte $00, $53, $48, $57, $4D, $53, $47, $01
	.byte $4E, $00, $01, $26, $23, $24, $30, $00
	.byte $2E, $50, $52, $49, $4E, $54, $01, $2E
	.byte $28, $4D, $53, $47, $4C, $29, $2C, $59
	.byte $00, $01, $21, $2E, $44, $4F, $4E, $45
	.byte $00, $01, $22, $45, $43, $48, $4F, $00
	.byte $01, $0D, $00, $01, $20, $2E, $50, $52
	.byte $49, $4E, $54, $00, $2E, $44, $4F, $4E
	.byte $45, $01, $19, $00, $02, $00, $41, $53
	.byte $43, $32, $48, $58, $01, $4E, $00, $01
	.byte $2B, $23, $24, $33, $30, $00, $01, $2F
	.byte $23, $24, $30, $41, $00, $01, $1E, $2E
	.byte $56, $41, $4C, $49, $44, $00, $01, $2C
	.byte $23, $24, $38, $38, $00, $01, $2F, $23
	.byte $24, $46, $41, $00, $01, $1E, $2E, $45
	.byte $52, $52, $00, $01, $2A, $23, $24, $30
	.byte $46, $00, $2E, $56, $41, $4C, $49, $44
	.byte $01, $19, $00, $2E, $45, $52, $52, $01
	.byte $2E, $23, $46, $41, $49, $4C, $00, $01
	.byte $19, $00, $02, $00, $42, $59, $54, $32
	.byte $48, $58, $01, $4E, $00, $01, $2E, $49
	.byte $4F, $42, $55, $46, $2C, $58, $00, $01
	.byte $22, $41, $53, $43, $32, $48, $58, $00
	.byte $01, $2F, $23, $46, $41, $49, $4C, $00
	.byte $01, $21, $2E, $45, $52, $52, $00, $01
	.byte $05, $00, $01, $0F, $00, $01, $2E, $49
	.byte $4F, $42, $55, $46, $2C, $58, $00, $01
	.byte $22, $41, $53, $43, $32, $48, $58, $00
	.byte $01, $2F, $23, $46, $41, $49, $4C, $00
	.byte $01, $20, $2E, $43, $4F, $4E, $54, $00
	.byte $01, $07, $00, $01, $19, $00, $2E, $43
	.byte $4F, $4E, $54, $01, $2D, $53, $43, $52
	.byte $54, $43, $48, $00, $01, $07, $00, $01
	.byte $31, $00, $01, $31, $00, $01, $31, $00
	.byte $01, $31, $00, $01, $2C, $53, $43, $52
	.byte $54, $43, $48, $00, $01, $19, $00, $2E
	.byte $45, $52, $52, $01, $2E, $23, $46, $41
	.byte $49, $4C, $00, $01, $19, $00, $02, $00
	.byte $49, $4E, $49, $54, $01, $4E, $00, $01
	.byte $2E, $23, $24, $30, $00, $01, $2D, $54
	.byte $55, $52, $4E, $00, $01, $37, $54, $55
	.byte $52, $4E, $00, $01, $2D, $53, $55, $4D
	.byte $00, $01, $2D, $54, $41, $52, $47, $45
	.byte $54, $00, $01, $38, $54, $41, $52, $47
	.byte $45, $54, $00, $01, $19, $00, $02, $00
	.byte $4D, $59, $50, $4C, $41, $59, $01, $4E
	.byte $00, $01, $2E, $23, $3C, $43, $4D, $50
	.byte $50, $4C, $59, $00, $01, $2D, $4D, $53
	.byte $47, $4C, $00, $01, $2E, $23, $3E, $43
	.byte $4D, $50, $50, $4C, $59, $00, $01, $2D
	.byte $4D, $53, $47, $48, $00, $01, $22, $53
	.byte $48, $57, $4D, $53, $47, $00, $01, $19
	.byte $00, $02, $00, $4D, $59, $4E, $55, $4D
	.byte $01, $4E, $00, $01, $2E, $53, $55, $4D
	.byte $00, $01, $2F, $54, $41, $52, $47, $45
	.byte $54, $00, $01, $21, $2E, $42, $41, $44
	.byte $00, $01, $1B, $2E, $47, $4F, $4F, $44
	.byte $00, $01, $2E, $23, $24, $31, $31, $00
	.byte $01, $02, $00, $01, $2C, $54, $41, $52
	.byte $47, $45, $54, $00, $01, $2D, $54, $41
	.byte $52, $47, $45, $54, $00, $01, $24, $4D
	.byte $59, $4E, $55, $4D, $00, $2E, $42, $41
	.byte $44, $01, $2E, $53, $55, $4D, $00, $01
	.byte $2C, $54, $41, $52, $47, $45, $54, $00
	.byte $01, $2A, $23, $24, $30, $46, $00, $01
	.byte $20, $2E, $53, $48, $4F, $57, $00, $01
	.byte $2E, $23, $24, $30, $35, $00, $01, $20
	.byte $2E, $53, $48, $4F, $57, $00, $2E, $47
	.byte $4F, $4F, $44, $01, $2E, $54, $41, $52
	.byte $47, $45, $54, $00, $01, $04, $00, $01
	.byte $30, $53, $55, $4D, $00, $2E, $53, $48
	.byte $4F, $57, $01, $05, $00, $01, $05, $00
	.byte $01, $22, $4D, $59, $50, $4C, $41, $59
	.byte $00, $01, $07, $00, $01, $22, $50, $52
	.byte $56, $41, $4C, $00, $01, $07, $00, $01
	.byte $19, $00, $02, $00, $59, $52, $4E, $55
	.byte $4D, $01, $4E, $00, $01, $22, $50, $52
	.byte $4F, $4D, $50, $54, $00, $01, $36, $23
	.byte $24, $30, $00, $01, $35, $49, $4F, $42
	.byte $55, $46, $00, $01, $35, $49, $4F, $42
	.byte $55, $46, $2B, $31, $00, $2E, $4F, $4E
	.byte $45, $43, $48, $01, $22, $47, $45, $54
	.byte $43, $48, $00, $01, $2F, $23, $43, $52
	.byte $00, $01, $21, $2E, $44, $4F, $4E, $45
	.byte $00, $01, $2F, $23, $27, $30, $27, $00
	.byte $01, $1B, $2E, $4F, $4E, $45, $43, $48
	.byte $00, $01, $2F, $23, $27, $39, $27, $2B
	.byte $31, $00, $01, $1A, $2E, $4F, $4E, $45
	.byte $43, $48, $00, $01, $2D, $49, $4F, $42
	.byte $55, $46, $2C, $58, $00, $01, $22, $45
	.byte $43, $48, $4F, $00, $01, $0F, $00, $01
	.byte $28, $23, $24, $32, $00, $01, $20, $2E
	.byte $4F, $4E, $45, $43, $48, $00, $2E, $44
	.byte $4F, $4E, $45, $01, $22, $43, $52, $4C
	.byte $46, $00, $01, $36, $23, $24, $30, $00
	.byte $01, $22, $42, $59, $54, $32, $48, $58
	.byte $00, $01, $21, $2E, $45, $52, $52, $00
	.byte $01, $2F, $23, $46, $41, $49, $4C, $00
	.byte $01, $21, $2E, $45, $52, $52, $00, $01
	.byte $2F, $23, $24, $31, $31, $00, $01, $1F
	.byte $2E, $45, $52, $52, $00, $01, $19, $00
	.byte $2E, $45, $52, $52, $01, $2E, $23, $3C
	.byte $45, $52, $52, $4F, $52, $00, $01, $2D
	.byte $4D, $53, $47, $4C, $00, $01, $2E, $23
	.byte $3E, $45, $52, $52, $4F, $52, $00, $01
	.byte $2D, $4D, $53, $47, $48, $00, $01, $22
	.byte $53, $48, $57, $4D, $53, $47, $00, $01
	.byte $22, $43, $52, $4C, $46, $00, $01, $24
	.byte $59, $52, $4E, $55, $4D, $00, $02, $00
	.byte $50, $52, $53, $55, $4D, $01, $4E, $00
	.byte $01, $2E, $23, $3C, $53, $55, $4D, $4C
	.byte $4E, $00, $01, $2D, $4D, $53, $47, $4C
	.byte $00, $01, $2E, $23, $3E, $53, $55, $4D
	.byte $4C, $4E, $00, $01, $2D, $4D, $53, $47
	.byte $48, $00, $01, $24, $53, $48, $57, $4D
	.byte $53, $47, $00, $02, $00, $59, $4F, $55
	.byte $4F, $52, $49, $01, $4E, $00, $01, $2E
	.byte $54, $55, $52, $4E, $00, $01, $34, $00
	.byte $01, $1E, $2E, $59, $4F, $55, $00, $01
	.byte $2E, $23, $27, $49, $27, $00, $01, $24
	.byte $45, $43, $48, $4F, $00, $2E, $59, $4F
	.byte $55, $01, $2E, $23, $3C, $59, $4F, $55
	.byte $00, $01, $2D, $4D, $53, $47, $4C, $00
	.byte $01, $2E, $23, $3E, $59, $4F, $55, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $01
	.byte $22, $53, $48, $57, $4D, $53, $47, $00
	.byte $01, $19, $00, $02, $00, $4D, $41, $49
	.byte $4E, $01, $4E, $00, $01, $10, $00, $01
	.byte $22, $49, $4E, $49, $54, $00, $2E, $50
	.byte $4C, $41, $59, $01, $38, $54, $55, $52
	.byte $4E, $00, $01, $22, $50, $52, $53, $55
	.byte $4D, $00, $01, $2E, $53, $55, $4D, $00
	.byte $01, $22, $50, $52, $56, $41, $4C, $00
	.byte $01, $2E, $54, $55, $52, $4E, $00, $01
	.byte $34, $00, $01, $1E, $2E, $50, $4C, $59
	.byte $52, $00, $01, $22, $4D, $59, $4E, $55
	.byte $4D, $00, $01, $20, $2E, $43, $4F, $4E
	.byte $54, $00, $2E, $50, $4C, $59, $52, $01
	.byte $22, $59, $52, $4E, $55, $4D, $00, $2E
	.byte $43, $4F, $4E, $54, $01, $02, $00, $01
	.byte $2C, $53, $55, $4D, $00, $01, $1F, $2E
	.byte $45, $4E, $44, $45, $44, $00, $01, $2D
	.byte $53, $55, $4D, $00, $01, $20, $2E, $50
	.byte $4C, $41, $59, $00, $2E, $45, $4E, $44
	.byte $45, $44, $01, $05, $00, $01, $05, $00
	.byte $01, $22, $43, $52, $4C, $46, $00, $01
	.byte $22, $50, $52, $53, $55, $4D, $00, $01
	.byte $2E, $23, $24, $31, $00, $01, $22, $50
	.byte $52, $48, $45, $58, $00, $01, $07, $00
	.byte $01, $22, $4F, $55, $54, $48, $45, $58
	.byte $00, $01, $22, $43, $52, $4C, $46, $00
	.byte $01, $22, $43, $52, $4C, $46, $00, $01
	.byte $22, $59, $4F, $55, $4F, $52, $49, $00
	.byte $01, $22, $4F, $55, $54, $53, $50, $00
	.byte $01, $07, $00, $01, $21, $2E, $57, $49
	.byte $4E, $00, $01, $2E, $23, $3C, $4C, $4F
	.byte $53, $45, $00, $01, $2D, $4D, $53, $47
	.byte $4C, $00, $01, $2E, $23, $3E, $4C, $4F
	.byte $53, $45, $00, $01, $2D, $4D, $53, $47
	.byte $48, $00, $01, $04, $00, $01, $1F, $2E
	.byte $53, $48, $4F, $57, $00, $2E, $57, $49
	.byte $4E, $01, $2E, $23, $3C, $57, $49, $4E
	.byte $00, $01, $2D, $4D, $53, $47, $4C, $00
	.byte $01, $2E, $23, $3E, $57, $49, $4E, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $2E
	.byte $53, $48, $4F, $57, $01, $22, $53, $48
	.byte $57, $4D, $53, $47, $00, $01, $22, $43
	.byte $52, $4C, $46, $00, $01, $22, $43, $52
	.byte $4C, $46, $00, $01, $24, $4D, $41, $49
	.byte $4E, $00, $00
NIM
	.byte $4F, $55, $54, $43, $48, $01, $3E, $24
	.byte $46, $46, $45, $46, $00, $50, $52, $48
	.byte $45, $58, $01, $3E, $24, $46, $46, $45
	.byte $35, $00, $4F, $55, $54, $48, $45, $58
	.byte $01, $3E, $24, $46, $46, $44, $43, $00
	.byte $4B, $42, $44, $01, $3E, $24, $44, $30
	.byte $31, $30, $00, $4B, $42, $44, $52, $44
	.byte $59, $01, $3E, $24, $44, $30, $31, $31
	.byte $00, $02, $00, $46, $41, $49, $4C, $01
	.byte $3E, $24, $46, $46, $00, $43, $52, $01
	.byte $3E, $24, $30, $44, $00, $4C, $46, $01
	.byte $3E, $24, $30, $41, $00, $53, $50, $01
	.byte $3E, $24, $32, $30, $00, $02, $00, $53
	.byte $43, $52, $54, $43, $48, $01, $3E, $24
	.byte $31, $30, $00, $4D, $53, $47, $4C, $01
	.byte $3E, $24, $31, $31, $00, $4D, $53, $47
	.byte $48, $01, $3E, $24, $31, $32, $00, $54
	.byte $55, $52, $4E, $01, $3E, $24, $31, $33
	.byte $00, $4E, $01, $3E, $24, $31, $34, $00
	.byte $56, $41, $4C, $53, $01, $3E, $24, $31
	.byte $35, $00, $02, $00, $49, $4E, $56, $01
	.byte $54, $27, $49, $4E, $56, $41, $4C, $49
	.byte $44, $27, $00, $01, $43, $24, $30, $00
	.byte $59, $4F, $55, $01, $54, $27, $59, $4F
	.byte $55, $27, $00, $01, $43, $24, $30, $00
	.byte $57, $49, $4E, $01, $54, $27, $57, $49
	.byte $4E, $21, $27, $00, $01, $43, $24, $30
	.byte $00, $43, $4D, $50, $50, $4C, $59, $01
	.byte $54, $27, $49, $27, $00, $01, $43, $53
	.byte $50, $00, $54, $41, $4B, $45, $01, $54
	.byte $27, $54, $41, $4B, $45, $27, $00, $01
	.byte $43, $24, $30, $00, $46, $52, $4F, $4D
	.byte $01, $54, $27, $46, $52, $4F, $4D, $27
	.byte $00, $01, $43, $53, $50, $00, $48, $45
	.byte $41, $50, $01, $54, $27, $48, $45, $41
	.byte $50, $27, $00, $01, $43, $24, $30, $00
	.byte $48, $45, $41, $50, $53, $01, $54, $27
	.byte $53, $27, $00, $01, $43, $53, $50, $00
	.byte $01, $54, $27, $41, $52, $45, $27, $00
	.byte $01, $43, $24, $30, $00, $02, $00, $47
	.byte $45, $54, $43, $48, $01, $4E, $00, $01
	.byte $2E, $4B, $42, $44, $52, $44, $59, $00
	.byte $01, $1A, $47, $45, $54, $43, $48, $00
	.byte $01, $2E, $4B, $42, $44, $00, $01, $2A
	.byte $23, $24, $37, $46, $00, $01, $24, $4F
	.byte $55, $54, $43, $48, $00, $02, $00, $50
	.byte $52, $4F, $4D, $50, $54, $01, $4E, $00
	.byte $01, $2E, $23, $27, $3F, $27, $00, $01
	.byte $22, $4F, $55, $54, $43, $48, $00, $4F
	.byte $55, $54, $53, $50, $01, $4E, $00, $01
	.byte $2E, $23, $53, $50, $00, $01, $24, $4F
	.byte $55, $54, $43, $48, $00, $02, $00, $43
	.byte $52, $4C, $46, $01, $4E, $00, $01, $2E
	.byte $23, $43, $52, $00, $01, $24, $4F, $55
	.byte $54, $43, $48, $00, $02, $00, $53, $48
	.byte $57, $4D, $53, $47, $01, $4E, $00, $01
	.byte $26, $23, $24, $30, $00, $2E, $50, $52
	.byte $49, $4E, $54, $01, $2E, $28, $4D, $53
	.byte $47, $4C, $29, $2C, $59, $00, $01, $21
	.byte $2E, $44, $4F, $4E, $45, $00, $01, $22
	.byte $4F, $55, $54, $43, $48, $00, $01, $0D
	.byte $00, $01, $20, $2E, $50, $52, $49, $4E
	.byte $54, $00, $2E, $44, $4F, $4E, $45, $01
	.byte $19, $00, $02, $00, $41, $53, $43, $32
	.byte $48, $58, $01, $4E, $00, $01, $2B, $23
	.byte $24, $33, $30, $00, $01, $2F, $23, $24
	.byte $30, $41, $00, $01, $1E, $2E, $56, $41
	.byte $4C, $49, $44, $00, $01, $2C, $23, $24
	.byte $38, $38, $00, $01, $2F, $23, $24, $46
	.byte $41, $00, $01, $1E, $2E, $45, $52, $52
	.byte $00, $01, $2A, $23, $24, $30, $46, $00
	.byte $2E, $56, $41, $4C, $49, $44, $01, $19
	.byte $00, $2E, $45, $52, $52, $01, $2E, $23
	.byte $46, $41, $49, $4C, $00, $01, $19, $00
	.byte $02, $00, $45, $52, $52, $4F, $52, $01
	.byte $4E, $00, $01, $22, $43, $52, $4C, $46
	.byte $00, $01, $2E, $23, $3C, $49, $4E, $56
	.byte $00, $01, $2D, $4D, $53, $47, $4C, $00
	.byte $01, $2E, $23, $3E, $49, $4E, $56, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $01
	.byte $22, $53, $48, $57, $4D, $53, $47, $00
	.byte $01, $24, $43, $52, $4C, $46, $00, $53
	.byte $48, $57, $48, $50, $01, $4E, $00, $01
	.byte $2E, $23, $3C, $48, $45, $41, $50, $00
	.byte $01, $2D, $4D, $53, $47, $4C, $00, $01
	.byte $2E, $23, $3E, $48, $45, $41, $50, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $01
	.byte $24, $53, $48, $57, $4D, $53, $47, $00
	.byte $02, $00, $47, $45, $54, $4E, $4D, $4D
	.byte $01, $4E, $00, $01, $22, $53, $48, $57
	.byte $4D, $53, $47, $00, $47, $45, $54, $4E
	.byte $4D, $01, $22, $50, $52, $4F, $4D, $50
	.byte $54, $00, $01, $22, $47, $45, $54, $43
	.byte $48, $00, $01, $24, $41, $53, $43, $32
	.byte $48, $58, $00, $02, $00, $49, $4E, $49
	.byte $54, $01, $4E, $00, $01, $2E, $23, $24
	.byte $30, $00, $01, $2D, $54, $55, $52, $4E
	.byte $00, $01, $37, $54, $55, $52, $4E, $00
	.byte $02, $00, $2E, $52, $50, $54, $01, $22
	.byte $43, $52, $4C, $46, $00, $01, $22, $53
	.byte $48, $57, $48, $50, $00, $01, $2E, $23
	.byte $27, $53, $27, $00, $01, $22, $4F, $55
	.byte $54, $43, $48, $00, $01, $22, $47, $45
	.byte $54, $4E, $4D, $00, $01, $13, $00, $01
	.byte $21, $2E, $45, $52, $52, $00, $01, $2F
	.byte $23, $46, $41, $49, $4C, $00, $01, $21
	.byte $2E, $45, $52, $52, $00, $01, $35, $4E
	.byte $00, $2E, $52, $50, $54, $31, $01, $26
	.byte $23, $27, $31, $27, $00, $01, $36, $23
	.byte $24, $30, $00, $2E, $4E, $45, $58, $54
	.byte $01, $22, $43, $52, $4C, $46, $00, $01
	.byte $0A, $00, $01, $22, $4F, $55, $54, $43
	.byte $48, $00, $01, $22, $47, $45, $54, $4E
	.byte $4D, $00, $01, $2F, $23, $24, $30, $00
	.byte $01, $21, $2E, $45, $52, $52, $31, $00
	.byte $01, $2F, $23, $46, $41, $49, $4C, $00
	.byte $01, $21, $2E, $45, $52, $52, $31, $00
	.byte $01, $2D, $56, $41, $4C, $53, $2C, $58
	.byte $00, $01, $0D, $00, $01, $0F, $00, $01
	.byte $28, $4E, $00, $01, $20, $2E, $4E, $45
	.byte $58, $54, $00, $01, $22, $43, $52, $4C
	.byte $46, $00, $01, $19, $00, $2E, $45, $52
	.byte $52, $01, $22, $45, $52, $52, $4F, $52
	.byte $00, $01, $24, $2E, $52, $50, $54, $00
	.byte $2E, $45, $52, $52, $31, $01, $22, $45
	.byte $52, $52, $4F, $52, $00, $01, $24, $2E
	.byte $52, $50, $54, $31, $00, $02, $00, $43
	.byte $41, $4C, $43, $47, $4F, $01, $4E, $00
	.byte $02, $00, $01, $36, $4E, $00, $01, $2E
	.byte $23, $24, $30, $00, $2E, $4E, $45, $58
	.byte $54, $01, $2B, $56, $41, $4C, $53, $2D
	.byte $31, $2C, $58, $00, $01, $15, $00, $01
	.byte $20, $2E, $4E, $45, $58, $54, $00, $01
	.byte $2D, $53, $43, $52, $54, $43, $48, $00
	.byte $01, $2F, $23, $24, $30, $00, $01, $21
	.byte $2E, $42, $41, $44, $00, $01, $36, $4E
	.byte $00, $2E, $4E, $45, $58, $54, $32, $01
	.byte $2E, $53, $43, $52, $54, $43, $48, $00
	.byte $01, $2B, $56, $41, $4C, $53, $2D, $31
	.byte $2C, $58, $00, $01, $2F, $56, $41, $4C
	.byte $53, $2D, $31, $2C, $58, $00, $01, $1B
	.byte $2E, $47, $4F, $4F, $44, $00, $01, $15
	.byte $00, $01, $20, $2E, $4E, $45, $58, $54
	.byte $32, $00, $2E, $47, $4F, $4F, $44, $01
	.byte $2D, $53, $43, $52, $54, $43, $48, $00
	.byte $01, $2E, $56, $41, $4C, $53, $2D, $31
	.byte $2C, $58, $00, $01, $04, $00, $01, $30
	.byte $53, $43, $52, $54, $43, $48, $00, $01
	.byte $19, $00, $2E, $42, $41, $44, $01, $36
	.byte $4E, $00, $2E, $4E, $45, $58, $54, $33
	.byte $01, $2E, $56, $41, $4C, $53, $2C, $58
	.byte $00, $01, $20, $2E, $4F, $4B, $00, $01
	.byte $15, $00, $01, $20, $2E, $4E, $45, $58
	.byte $54, $33, $00, $2E, $4F, $4B, $01, $2E
	.byte $23, $24, $31, $00, $01, $19, $00, $02
	.byte $00, $4D, $59, $47, $4F, $01, $4E, $00
	.byte $01, $2E, $23, $3C, $43, $4D, $50, $50
	.byte $4C, $59, $00, $01, $2D, $4D, $53, $47
	.byte $4C, $00, $01, $2E, $23, $3E, $43, $4D
	.byte $50, $50, $4C, $59, $00, $01, $2D, $4D
	.byte $53, $47, $48, $00, $01, $22, $53, $48
	.byte $57, $4D, $53, $47, $00, $01, $22, $4F
	.byte $55, $54, $53, $50, $00, $01, $22, $43
	.byte $41, $4C, $43, $47, $4F, $00, $01, $2D
	.byte $53, $43, $52, $54, $43, $48, $00, $01
	.byte $22, $50, $52, $48, $45, $58, $00, $01
	.byte $22, $4F, $55, $54, $53, $50, $00, $01
	.byte $2E, $23, $3C, $46, $52, $4F, $4D, $00
	.byte $01, $2D, $4D, $53, $47, $4C, $00, $01
	.byte $2E, $23, $3E, $46, $52, $4F, $4D, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $01
	.byte $22, $53, $48, $57, $4D, $53, $47, $00
	.byte $01, $22, $4F, $55, $54, $53, $50, $00
	.byte $01, $11, $00, $01, $22, $50, $52, $48
	.byte $45, $58, $00, $01, $15, $00, $55, $50
	.byte $44, $54, $48, $50, $01, $4E, $00, $01
	.byte $2E, $56, $41, $4C, $53, $2C, $58, $00
	.byte $01, $04, $00, $01, $30, $53, $43, $52
	.byte $54, $43, $48, $00, $01, $2D, $56, $41
	.byte $4C, $53, $2C, $58, $00, $01, $22, $43
	.byte $52, $4C, $46, $00, $01, $19, $00, $02
	.byte $00, $59, $52, $47, $4F, $01, $4E, $00
	.byte $01, $22, $53, $48, $57, $48, $50, $00
	.byte $01, $22, $47, $45, $54, $4E, $4D, $00
	.byte $01, $13, $00, $01, $21, $2E, $45, $52
	.byte $52, $00, $01, $28, $23, $46, $41, $49
	.byte $4C, $00, $01, $21, $2E, $45, $52, $52
	.byte $00, $01, $28, $4E, $00, $01, $21, $2E
	.byte $4F, $4B, $00, $01, $1F, $2E, $45, $52
	.byte $52, $00, $2E, $4F, $4B, $01, $15, $00
	.byte $01, $22, $43, $52, $4C, $46, $00, $01
	.byte $2E, $23, $3C, $54, $41, $4B, $45, $00
	.byte $01, $2D, $4D, $53, $47, $4C, $00, $01
	.byte $2E, $23, $3E, $54, $41, $4B, $45, $00
	.byte $01, $2D, $4D, $53, $47, $48, $00, $01
	.byte $22, $47, $45, $54, $4E, $4D, $4D, $00
	.byte $01, $2F, $23, $24, $30, $00, $01, $21
	.byte $2E, $45, $52, $52, $00, $01, $2F, $23
	.byte $46, $41, $49, $4C, $00, $01, $21, $2E
	.byte $45, $52, $52, $00, $01, $2F, $56, $41
	.byte $4C, $53, $2C, $58, $00, $01, $21, $2E
	.byte $55, $50, $44, $00, $01, $1F, $2E, $45
	.byte $52, $52, $00, $2E, $55, $50, $44, $01
	.byte $2D, $53, $43, $52, $54, $43, $48, $00
	.byte $01, $24, $55, $50, $44, $54, $48, $50
	.byte $00, $2E, $45, $52, $52, $01, $22, $45
	.byte $52, $52, $4F, $52, $00, $01, $24, $59
	.byte $52, $47, $4F, $00, $02, $00, $50, $52
	.byte $48, $45, $41, $50, $01, $4E, $00, $01
	.byte $22, $53, $48, $57, $48, $50, $00, $01
	.byte $2E, $23, $3C, $48, $45, $41, $50, $53
	.byte $00, $01, $2D, $4D, $53, $47, $4C, $00
	.byte $01, $2E, $23, $3E, $48, $45, $41, $50
	.byte $53, $00, $01, $2D, $4D, $53, $47, $48
	.byte $00, $01, $22, $53, $48, $57, $4D, $53
	.byte $47, $00, $01, $36, $23, $24, $30, $00
	.byte $2E, $4E, $45, $58, $54, $01, $22, $4F
	.byte $55, $54, $53, $50, $00, $01, $2E, $56
	.byte $41, $4C, $53, $2C, $58, $00, $01, $22
	.byte $50, $52, $48, $45, $58, $00, $01, $0F
	.byte $00, $01, $28, $4E, $00, $01, $1B, $2E
	.byte $4E, $45, $58, $54, $00, $01, $22, $43
	.byte $52, $4C, $46, $00, $01, $19, $00, $02
	.byte $00, $59, $4F, $55, $4F, $52, $49, $01
	.byte $4E, $00, $01, $2E, $54, $55, $52, $4E
	.byte $00, $01, $34, $00, $01, $1E, $2E, $59
	.byte $4F, $55, $00, $01, $2E, $23, $27, $49
	.byte $27, $00, $01, $24, $4F, $55, $54, $43
	.byte $48, $00, $2E, $59, $4F, $55, $01, $2E
	.byte $23, $3C, $59, $4F, $55, $00, $01, $2D
	.byte $4D, $53, $47, $4C, $00, $01, $2E, $23
	.byte $3E, $59, $4F, $55, $00, $01, $2D, $4D
	.byte $53, $47, $48, $00, $2E, $53, $48, $4F
	.byte $57, $01, $22, $53, $48, $57, $4D, $53
	.byte $47, $00, $01, $19, $00, $02, $00, $4D
	.byte $41, $49, $4E, $01, $4E, $00, $01, $22
	.byte $49, $4E, $49, $54, $00, $2E, $50, $4C
	.byte $41, $59, $01, $38, $54, $55, $52, $4E
	.byte $00, $01, $22, $50, $52, $48, $45, $41
	.byte $50, $00, $01, $2E, $54, $55, $52, $4E
	.byte $00, $01, $34, $00, $01, $1E, $2E, $50
	.byte $4C, $59, $52, $00, $01, $22, $4D, $59
	.byte $47, $4F, $00, $01, $04, $00, $01, $1F
	.byte $2E, $43, $4F, $4E, $54, $00, $2E, $50
	.byte $4C, $59, $52, $01, $22, $59, $52, $47
	.byte $4F, $00, $2E, $43, $4F, $4E, $54, $01
	.byte $22, $43, $52, $4C, $46, $00, $01, $36
	.byte $4E, $00, $2E, $43, $48, $45, $43, $4B
	.byte $01, $2E, $56, $41, $4C, $53, $2D, $31
	.byte $2C, $58, $00, $01, $20, $2E, $50, $4C
	.byte $41, $59, $00, $01, $15, $00, $01, $20
	.byte $2E, $43, $48, $45, $43, $4B, $00, $01
	.byte $22, $50, $52, $48, $45, $41, $50, $00
	.byte $01, $22, $43, $52, $4C, $46, $00, $01
	.byte $22, $59, $4F, $55, $4F, $52, $49, $00
	.byte $01, $22, $4F, $55, $54, $53, $50, $00
	.byte $2E, $57, $49, $4E, $01, $2E, $23, $3C
	.byte $57, $49, $4E, $00, $01, $2D, $4D, $53
	.byte $47, $4C, $00, $01, $2E, $23, $3E, $57
	.byte $49, $4E, $00, $01, $2D, $4D, $53, $47
	.byte $48, $00, $01, $22, $53, $48, $57, $4D
	.byte $53, $47, $00, $01, $22, $43, $52, $4C
	.byte $46, $00, $01, $22, $43, $52, $4C, $46
	.byte $00, $01, $22, $47, $45, $54, $43, $48
	.byte $00, $01, $24, $4D, $41, $49, $4E, $00
	.byte $00
END

MMSZ = HG-MM
HGSZ = NIM-HG
NIMSZ = END-NIM

; tables
SRCL
	.byte <MM
	.byte <HG
	.byte <NIM
SRCH
	.byte >MM
	.byte >HG
	.byte >NIM
SZL
	.byte <MMSZ
	.byte <HGSZ
	.byte <NIMSZ
SZH
	.byte >MMSZ
	.byte >HGSZ
	.byte >NIMSZ
	
	.if APPLE1
; Apple 1 I/O values
OUTCH	=$FFEF		; Apple 1 Echo
PRHEX	=$FFE5		; Apple 1 Echo
OUTHEX	=$FFDC		; Apple 1 Print Hex Byte Routine
KBD     =$D010		; Apple 1 Keyboard character read.
KBDRDY  =$D011		; Apple 1 Keyboard data waiting when negative.
	.else
IOMEM	=$E000
PUTCH	=IOMEM+1
KBD	=IOMEM+4
KBDRDY  =IOMEM+4
	.ORG $FB82
MOVE			; Move memory down
	LDY #$00
	LDX SIZEH
	BEQ .MD2
.MD1	LDA (FROM),Y ; move a page at a time
	STA (TO),Y
	INY
	BNE .MD1
	INC FROM+1
	INC TO+1
	DEX
	BNE .MD1
.MD2	LDX SIZEL
	BEQ .MD4
.MD3	LDA (FROM),Y ; move the remaining bytes
	STA (TO),Y
	INY
	DEX
	BNE .MD3
.MD4	RTS
	.ORG $FFDC
OUTHEX	PHA 		; Print 1 hex byte. 
	LSR
	LSR 
	LSR
	LSR 
	JSR PRHEX
	PLA 
PRHEX	AND #$0F	; Print 1 hex digit
	ORA #$30
	CMP #$3A
	BCC OUTCH
	ADC #$06
OUTCH	STA PUTCH
	RTS  
	.endif